package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNetworkSiteResponse(
    networkSite: Optional[zio.aws.privatenetworks.model.NetworkSite] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteResponse = {
    import GetNetworkSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteResponse
      .builder()
      .optionallyWith(networkSite.map(value => value.buildAwsValue()))(
        _.networkSite
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly =
    zio.aws.privatenetworks.model.GetNetworkSiteResponse.wrap(buildAwsValue())
}
object GetNetworkSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetNetworkSiteResponse =
      zio.aws.privatenetworks.model.GetNetworkSiteResponse(
        networkSite.map(value => value.asEditable),
        tags.map(value => value)
      )
    def networkSite
        : Optional[zio.aws.privatenetworks.model.NetworkSite.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getNetworkSite: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkSite.ReadOnly
    ] = AwsError.unwrapOptionField("networkSite", networkSite)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteResponse
  ) extends zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly {
    override val networkSite
        : Optional[zio.aws.privatenetworks.model.NetworkSite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSite())
        .map(value => zio.aws.privatenetworks.model.NetworkSite.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteResponse
  ): zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly =
    new Wrapper(impl)
}
