package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNetworkResponse(
    network: zio.aws.privatenetworks.model.Network,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetNetworkResponse = {
    import GetNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkResponse
      .builder()
      .network(network.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly =
    zio.aws.privatenetworks.model.GetNetworkResponse.wrap(buildAwsValue())
}
object GetNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetNetworkResponse =
      zio.aws.privatenetworks.model
        .GetNetworkResponse(network.asEditable, tags.map(value => value))
    def network: zio.aws.privatenetworks.model.Network.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.Network.ReadOnly] =
      ZIO.succeed(network)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkResponse
  ) extends zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly {
    override val network: zio.aws.privatenetworks.model.Network.ReadOnly =
      zio.aws.privatenetworks.model.Network.wrap(impl.network())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkResponse
  ): zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly = new Wrapper(
    impl
  )
}
