package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNetworkResourceResponse(
    networkResource: zio.aws.privatenetworks.model.NetworkResource,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceResponse = {
    import GetNetworkResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceResponse
      .builder()
      .networkResource(networkResource.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly =
    zio.aws.privatenetworks.model.GetNetworkResourceResponse
      .wrap(buildAwsValue())
}
object GetNetworkResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetNetworkResourceResponse =
      zio.aws.privatenetworks.model.GetNetworkResourceResponse(
        networkResource.asEditable,
        tags.map(value => value)
      )
    def networkResource: zio.aws.privatenetworks.model.NetworkResource.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getNetworkResource: ZIO[
      Any,
      Nothing,
      zio.aws.privatenetworks.model.NetworkResource.ReadOnly
    ] = ZIO.succeed(networkResource)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceResponse
  ) extends zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly {
    override val networkResource
        : zio.aws.privatenetworks.model.NetworkResource.ReadOnly =
      zio.aws.privatenetworks.model.NetworkResource.wrap(impl.networkResource())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceResponse
  ): zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly =
    new Wrapper(impl)
}
