package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDeviceIdentifierResponse(
    deviceIdentifier: Optional[zio.aws.privatenetworks.model.DeviceIdentifier] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierResponse = {
    import GetDeviceIdentifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierResponse
      .builder()
      .optionallyWith(deviceIdentifier.map(value => value.buildAwsValue()))(
        _.deviceIdentifier
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly =
    zio.aws.privatenetworks.model.GetDeviceIdentifierResponse
      .wrap(buildAwsValue())
}
object GetDeviceIdentifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetDeviceIdentifierResponse =
      zio.aws.privatenetworks.model.GetDeviceIdentifierResponse(
        deviceIdentifier.map(value => value.asEditable),
        tags.map(value => value)
      )
    def deviceIdentifier
        : Optional[zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDeviceIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("deviceIdentifier", deviceIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierResponse
  ) extends zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly {
    override val deviceIdentifier
        : Optional[zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceIdentifier())
        .map(value =>
          zio.aws.privatenetworks.model.DeviceIdentifier.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierResponse
  ): zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly =
    new Wrapper(impl)
}
