package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteNetworkSiteResponse(
    networkSite: Optional[zio.aws.privatenetworks.model.NetworkSite] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteResponse = {
    import DeleteNetworkSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteResponse
      .builder()
      .optionallyWith(networkSite.map(value => value.buildAwsValue()))(
        _.networkSite
      )
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly =
    zio.aws.privatenetworks.model.DeleteNetworkSiteResponse
      .wrap(buildAwsValue())
}
object DeleteNetworkSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.DeleteNetworkSiteResponse =
      zio.aws.privatenetworks.model
        .DeleteNetworkSiteResponse(networkSite.map(value => value.asEditable))
    def networkSite
        : Optional[zio.aws.privatenetworks.model.NetworkSite.ReadOnly]
    def getNetworkSite: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkSite.ReadOnly
    ] = AwsError.unwrapOptionField("networkSite", networkSite)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteResponse
  ) extends zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly {
    override val networkSite
        : Optional[zio.aws.privatenetworks.model.NetworkSite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSite())
        .map(value => zio.aws.privatenetworks.model.NetworkSite.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteResponse
  ): zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly =
    new Wrapper(impl)
}
