package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{
  TagValue,
  Description,
  ClientToken,
  Name,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNetworkRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    networkName: Name,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest = {
    import CreateNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .networkName(Name.unwrap(networkName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.CreateNetworkRequest.ReadOnly =
    zio.aws.privatenetworks.model.CreateNetworkRequest.wrap(buildAwsValue())
}
object CreateNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.CreateNetworkRequest =
      zio.aws.privatenetworks.model.CreateNetworkRequest(
        clientToken.map(value => value),
        description.map(value => value),
        networkName,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def networkName: Name
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNetworkName: ZIO[Any, Nothing, Name] = ZIO.succeed(networkName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest
  ) extends zio.aws.privatenetworks.model.CreateNetworkRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.privatenetworks.model.primitives.Description(value))
    override val networkName: Name =
      zio.aws.privatenetworks.model.primitives.Name(impl.networkName())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest
  ): zio.aws.privatenetworks.model.CreateNetworkRequest.ReadOnly = new Wrapper(
    impl
  )
}
