package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{
  ConfigureAccessPointRequestCpiSecretKeyString,
  ConfigureAccessPointRequestCpiUsernameString,
  Arn,
  ConfigureAccessPointRequestCpiUserIdString,
  ConfigureAccessPointRequestCpiUserPasswordString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigureAccessPointRequest(
    accessPointArn: Arn,
    cpiSecretKey: Optional[ConfigureAccessPointRequestCpiSecretKeyString] =
      Optional.Absent,
    cpiUserId: Optional[ConfigureAccessPointRequestCpiUserIdString] =
      Optional.Absent,
    cpiUserPassword: Optional[
      ConfigureAccessPointRequestCpiUserPasswordString
    ] = Optional.Absent,
    cpiUsername: Optional[ConfigureAccessPointRequestCpiUsernameString] =
      Optional.Absent,
    position: Optional[zio.aws.privatenetworks.model.Position] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest = {
    import ConfigureAccessPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest
      .builder()
      .accessPointArn(Arn.unwrap(accessPointArn): java.lang.String)
      .optionallyWith(
        cpiSecretKey.map(value =>
          ConfigureAccessPointRequestCpiSecretKeyString.unwrap(
            value
          ): java.lang.String
        )
      )(_.cpiSecretKey)
      .optionallyWith(
        cpiUserId.map(value =>
          ConfigureAccessPointRequestCpiUserIdString.unwrap(
            value
          ): java.lang.String
        )
      )(_.cpiUserId)
      .optionallyWith(
        cpiUserPassword.map(value =>
          ConfigureAccessPointRequestCpiUserPasswordString.unwrap(
            value
          ): java.lang.String
        )
      )(_.cpiUserPassword)
      .optionallyWith(
        cpiUsername.map(value =>
          ConfigureAccessPointRequestCpiUsernameString.unwrap(
            value
          ): java.lang.String
        )
      )(_.cpiUsername)
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ConfigureAccessPointRequest.ReadOnly =
    zio.aws.privatenetworks.model.ConfigureAccessPointRequest
      .wrap(buildAwsValue())
}
object ConfigureAccessPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ConfigureAccessPointRequest =
      zio.aws.privatenetworks.model.ConfigureAccessPointRequest(
        accessPointArn,
        cpiSecretKey.map(value => value),
        cpiUserId.map(value => value),
        cpiUserPassword.map(value => value),
        cpiUsername.map(value => value),
        position.map(value => value.asEditable)
      )
    def accessPointArn: Arn
    def cpiSecretKey: Optional[ConfigureAccessPointRequestCpiSecretKeyString]
    def cpiUserId: Optional[ConfigureAccessPointRequestCpiUserIdString]
    def cpiUserPassword
        : Optional[ConfigureAccessPointRequestCpiUserPasswordString]
    def cpiUsername: Optional[ConfigureAccessPointRequestCpiUsernameString]
    def position: Optional[zio.aws.privatenetworks.model.Position.ReadOnly]
    def getAccessPointArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(accessPointArn)
    def getCpiSecretKey
        : ZIO[Any, AwsError, ConfigureAccessPointRequestCpiSecretKeyString] =
      AwsError.unwrapOptionField("cpiSecretKey", cpiSecretKey)
    def getCpiUserId
        : ZIO[Any, AwsError, ConfigureAccessPointRequestCpiUserIdString] =
      AwsError.unwrapOptionField("cpiUserId", cpiUserId)
    def getCpiUserPassword
        : ZIO[Any, AwsError, ConfigureAccessPointRequestCpiUserPasswordString] =
      AwsError.unwrapOptionField("cpiUserPassword", cpiUserPassword)
    def getCpiUsername
        : ZIO[Any, AwsError, ConfigureAccessPointRequestCpiUsernameString] =
      AwsError.unwrapOptionField("cpiUsername", cpiUsername)
    def getPosition
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.Position.ReadOnly] =
      AwsError.unwrapOptionField("position", position)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest
  ) extends zio.aws.privatenetworks.model.ConfigureAccessPointRequest.ReadOnly {
    override val accessPointArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.accessPointArn())
    override val cpiSecretKey
        : Optional[ConfigureAccessPointRequestCpiSecretKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpiSecretKey())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ConfigureAccessPointRequestCpiSecretKeyString(value)
        )
    override val cpiUserId
        : Optional[ConfigureAccessPointRequestCpiUserIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpiUserId())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ConfigureAccessPointRequestCpiUserIdString(value)
        )
    override val cpiUserPassword
        : Optional[ConfigureAccessPointRequestCpiUserPasswordString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpiUserPassword())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ConfigureAccessPointRequestCpiUserPasswordString(value)
        )
    override val cpiUsername
        : Optional[ConfigureAccessPointRequestCpiUsernameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpiUsername())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ConfigureAccessPointRequestCpiUsernameString(value)
        )
    override val position
        : Optional[zio.aws.privatenetworks.model.Position.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value => zio.aws.privatenetworks.model.Position.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest
  ): zio.aws.privatenetworks.model.ConfigureAccessPointRequest.ReadOnly =
    new Wrapper(impl)
}
