package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AcknowledgeOrderReceiptResponse(
    order: zio.aws.privatenetworks.model.Order
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptResponse = {
    import AcknowledgeOrderReceiptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptResponse
      .builder()
      .order(order.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly =
    zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse
      .wrap(buildAwsValue())
}
object AcknowledgeOrderReceiptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse =
      zio.aws.privatenetworks.model
        .AcknowledgeOrderReceiptResponse(order.asEditable)
    def order: zio.aws.privatenetworks.model.Order.ReadOnly
    def getOrder
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.Order.ReadOnly] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptResponse
  ) extends zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly {
    override val order: zio.aws.privatenetworks.model.Order.ReadOnly =
      zio.aws.privatenetworks.model.Order.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptResponse
  ): zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly =
    new Wrapper(impl)
}
