package zio.aws.privatenetworks
import zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.privatenetworks.model.{
  ListOrdersRequest,
  DeleteNetworkRequest,
  ListNetworkSitesRequest,
  GetDeviceIdentifierRequest,
  DeactivateDeviceIdentifierRequest,
  GetNetworkRequest,
  ActivateNetworkSiteRequest,
  UpdateNetworkSitePlanRequest,
  ActivateDeviceIdentifierRequest,
  ListNetworkResourcesRequest,
  CreateNetworkSiteRequest,
  ListTagsForResourceRequest,
  ConfigureAccessPointRequest,
  DeleteNetworkSiteRequest,
  ListDeviceIdentifiersRequest,
  GetNetworkSiteRequest,
  UntagResourceRequest,
  AcknowledgeOrderReceiptRequest,
  UpdateNetworkSiteRequest,
  GetOrderRequest,
  GetNetworkResourceRequest,
  ListNetworksRequest,
  TagResourceRequest,
  CreateNetworkRequest
}
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksAsyncClient
import zio.stream.ZStream
object PrivateNetworksMock extends Mock[PrivateNetworks] {
  object AcknowledgeOrderReceipt
      extends Effect[
        AcknowledgeOrderReceiptRequest,
        AwsError,
        zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly
      ]
  object ActivateNetworkSite
      extends Effect[
        ActivateNetworkSiteRequest,
        AwsError,
        zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly
      ]
  object GetNetwork
      extends Effect[
        GetNetworkRequest,
        AwsError,
        zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly
      ]
  object ListDeviceIdentifiers
      extends Stream[ListDeviceIdentifiersRequest, AwsError, ReadOnly]
  object ListDeviceIdentifiersPaginated
      extends Effect[
        ListDeviceIdentifiersRequest,
        AwsError,
        zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly
      ]
  object ConfigureAccessPoint
      extends Effect[
        ConfigureAccessPointRequest,
        AwsError,
        zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly
      ]
  object CreateNetwork
      extends Effect[
        CreateNetworkRequest,
        AwsError,
        zio.aws.privatenetworks.model.CreateNetworkResponse.ReadOnly
      ]
  object DeleteNetworkSite
      extends Effect[
        DeleteNetworkSiteRequest,
        AwsError,
        zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly
      ]
  object CreateNetworkSite
      extends Effect[
        CreateNetworkSiteRequest,
        AwsError,
        zio.aws.privatenetworks.model.CreateNetworkSiteResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.privatenetworks.model.UntagResourceResponse.ReadOnly
      ]
  object GetDeviceIdentifier
      extends Effect[
        GetDeviceIdentifierRequest,
        AwsError,
        zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly
      ]
  object ListNetworks
      extends Stream[
        ListNetworksRequest,
        AwsError,
        zio.aws.privatenetworks.model.Network.ReadOnly
      ]
  object ListNetworksPaginated
      extends Effect[
        ListNetworksRequest,
        AwsError,
        zio.aws.privatenetworks.model.ListNetworksResponse.ReadOnly
      ]
  object ActivateDeviceIdentifier
      extends Effect[
        ActivateDeviceIdentifierRequest,
        AwsError,
        zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly
      ]
  object UpdateNetworkSite
      extends Effect[
        UpdateNetworkSiteRequest,
        AwsError,
        zio.aws.privatenetworks.model.UpdateNetworkSiteResponse.ReadOnly
      ]
  object GetOrder
      extends Effect[
        GetOrderRequest,
        AwsError,
        zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.privatenetworks.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListNetworkSites
      extends Stream[
        ListNetworkSitesRequest,
        AwsError,
        zio.aws.privatenetworks.model.NetworkSite.ReadOnly
      ]
  object ListNetworkSitesPaginated
      extends Effect[
        ListNetworkSitesRequest,
        AwsError,
        zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.privatenetworks.model.TagResourceResponse.ReadOnly
      ]
  object UpdateNetworkSitePlan
      extends Effect[
        UpdateNetworkSitePlanRequest,
        AwsError,
        zio.aws.privatenetworks.model.UpdateNetworkSitePlanResponse.ReadOnly
      ]
  object GetNetworkSite
      extends Effect[
        GetNetworkSiteRequest,
        AwsError,
        zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly
      ]
  object ListNetworkResources
      extends Stream[
        ListNetworkResourcesRequest,
        AwsError,
        zio.aws.privatenetworks.model.NetworkResource.ReadOnly
      ]
  object ListNetworkResourcesPaginated
      extends Effect[
        ListNetworkResourcesRequest,
        AwsError,
        zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly
      ]
  object Ping
      extends Effect[
        Unit,
        AwsError,
        zio.aws.privatenetworks.model.PingResponse.ReadOnly
      ]
  object ListOrders
      extends Stream[
        ListOrdersRequest,
        AwsError,
        zio.aws.privatenetworks.model.Order.ReadOnly
      ]
  object ListOrdersPaginated
      extends Effect[
        ListOrdersRequest,
        AwsError,
        zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly
      ]
  object DeleteNetwork
      extends Effect[
        DeleteNetworkRequest,
        AwsError,
        zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly
      ]
  object GetNetworkResource
      extends Effect[
        GetNetworkResourceRequest,
        AwsError,
        zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly
      ]
  object DeactivateDeviceIdentifier
      extends Effect[
        DeactivateDeviceIdentifierRequest,
        AwsError,
        zio.aws.privatenetworks.model.DeactivateDeviceIdentifierResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, PrivateNetworks] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, PrivateNetworks] { rts =>
        zio.ZIO.succeed {
          new PrivateNetworks {
            val api: PrivateNetworksAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): PrivateNetworks = this
            def acknowledgeOrderReceipt(
                request: AcknowledgeOrderReceiptRequest
            ): IO[
              AwsError,
              zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly
            ] = proxy(AcknowledgeOrderReceipt, request)
            def activateNetworkSite(request: ActivateNetworkSiteRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly
            ] = proxy(ActivateNetworkSite, request)
            def getNetwork(request: GetNetworkRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly
            ] = proxy(GetNetwork, request)
            def listDeviceIdentifiers(
                request: ListDeviceIdentifiersRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDeviceIdentifiers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDeviceIdentifiersPaginated(
                request: ListDeviceIdentifiersRequest
            ): IO[
              AwsError,
              zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly
            ] = proxy(ListDeviceIdentifiersPaginated, request)
            def configureAccessPoint(request: ConfigureAccessPointRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly
            ] = proxy(ConfigureAccessPoint, request)
            def createNetwork(request: CreateNetworkRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.CreateNetworkResponse.ReadOnly
            ] = proxy(CreateNetwork, request)
            def deleteNetworkSite(request: DeleteNetworkSiteRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly
            ] = proxy(DeleteNetworkSite, request)
            def createNetworkSite(request: CreateNetworkSiteRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.CreateNetworkSiteResponse.ReadOnly
            ] = proxy(CreateNetworkSite, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getDeviceIdentifier(request: GetDeviceIdentifierRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly
            ] = proxy(GetDeviceIdentifier, request)
            def listNetworks(request: ListNetworksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.privatenetworks.model.Network.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNetworks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNetworksPaginated(request: ListNetworksRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.ListNetworksResponse.ReadOnly
            ] = proxy(ListNetworksPaginated, request)
            def activateDeviceIdentifier(
                request: ActivateDeviceIdentifierRequest
            ): IO[
              AwsError,
              zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly
            ] = proxy(ActivateDeviceIdentifier, request)
            def updateNetworkSite(request: UpdateNetworkSiteRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.UpdateNetworkSiteResponse.ReadOnly
            ] = proxy(UpdateNetworkSite, request)
            def getOrder(request: GetOrderRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly
            ] = proxy(GetOrder, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listNetworkSites(request: ListNetworkSitesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.privatenetworks.model.NetworkSite.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNetworkSites, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNetworkSitesPaginated(request: ListNetworkSitesRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly
            ] = proxy(ListNetworkSitesPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateNetworkSitePlan(
                request: UpdateNetworkSitePlanRequest
            ): IO[
              AwsError,
              zio.aws.privatenetworks.model.UpdateNetworkSitePlanResponse.ReadOnly
            ] = proxy(UpdateNetworkSitePlan, request)
            def getNetworkSite(request: GetNetworkSiteRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly
            ] = proxy(GetNetworkSite, request)
            def listNetworkResources(
                request: ListNetworkResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.privatenetworks.model.NetworkResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNetworkResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNetworkResourcesPaginated(
                request: ListNetworkResourcesRequest
            ): IO[
              AwsError,
              zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly
            ] = proxy(ListNetworkResourcesPaginated, request)
            def ping(): IO[
              AwsError,
              zio.aws.privatenetworks.model.PingResponse.ReadOnly
            ] = proxy(Ping)
            def listOrders(request: ListOrdersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.privatenetworks.model.Order.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOrders, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOrdersPaginated(request: ListOrdersRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly
            ] = proxy(ListOrdersPaginated, request)
            def deleteNetwork(request: DeleteNetworkRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly
            ] = proxy(DeleteNetwork, request)
            def getNetworkResource(request: GetNetworkResourceRequest): IO[
              AwsError,
              zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly
            ] = proxy(GetNetworkResource, request)
            def deactivateDeviceIdentifier(
                request: DeactivateDeviceIdentifierRequest
            ): IO[
              AwsError,
              zio.aws.privatenetworks.model.DeactivateDeviceIdentifierResponse.ReadOnly
            ] = proxy(DeactivateDeviceIdentifier, request)
          }
        }
      }
    }
  }
}
