package zio.aws.privatenetworks
import zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.privatenetworks.paginators.{
  ListNetworksPublisher,
  ListNetworkResourcesPublisher,
  ListNetworkSitesPublisher,
  ListDeviceIdentifiersPublisher,
  ListOrdersPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.privatenetworks.model.{
  ListOrdersRequest,
  DeleteNetworkRequest,
  ListNetworkSitesRequest,
  GetDeviceIdentifierRequest,
  DeactivateDeviceIdentifierRequest,
  GetNetworkRequest,
  ActivateNetworkSiteRequest,
  UpdateNetworkSitePlanRequest,
  ActivateDeviceIdentifierRequest,
  ListNetworkResourcesRequest,
  CreateNetworkSiteRequest,
  ListTagsForResourceRequest,
  ConfigureAccessPointRequest,
  DeleteNetworkSiteRequest,
  ListDeviceIdentifiersRequest,
  GetNetworkSiteRequest,
  UntagResourceRequest,
  AcknowledgeOrderReceiptRequest,
  UpdateNetworkSiteRequest,
  GetOrderRequest,
  GetNetworkResourceRequest,
  ListNetworksRequest,
  TagResourceRequest,
  CreateNetworkRequest
}
import software.amazon.awssdk.services.privatenetworks.{
  PrivateNetworksAsyncClientBuilder,
  PrivateNetworksAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.privatenetworks.model.{
  UpdateNetworkSitePlanResponse,
  DeleteNetworkSiteResponse,
  CreateNetworkSiteResponse,
  ActivateDeviceIdentifierResponse,
  ListNetworkResourcesResponse,
  Order,
  DeleteNetworkResponse,
  GetNetworkResourceResponse,
  CreateNetworkResponse,
  DeactivateDeviceIdentifierResponse,
  NetworkResource,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetDeviceIdentifierResponse,
  DeviceIdentifier,
  NetworkSite,
  ConfigureAccessPointResponse,
  Network,
  GetOrderResponse,
  ActivateNetworkSiteResponse,
  PingRequest,
  GetNetworkSiteResponse,
  UpdateNetworkSiteResponse,
  GetNetworkResponse,
  PingResponse,
  ListDeviceIdentifiersResponse,
  ListNetworksResponse,
  TagResourceResponse,
  ListOrdersResponse,
  AcknowledgeOrderReceiptResponse,
  ListNetworkSitesResponse
}
import scala.jdk.CollectionConverters.*
trait PrivateNetworks extends AspectSupport[PrivateNetworks] {
  val api: PrivateNetworksAsyncClient
  def acknowledgeOrderReceipt(request: AcknowledgeOrderReceiptRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly
  ]
  def activateNetworkSite(request: ActivateNetworkSiteRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly
  ]
  def getNetwork(
      request: GetNetworkRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly]
  def listDeviceIdentifiers(
      request: ListDeviceIdentifiersRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listDeviceIdentifiersPaginated(request: ListDeviceIdentifiersRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly
  ]
  def configureAccessPoint(request: ConfigureAccessPointRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly
  ]
  def createNetwork(
      request: CreateNetworkRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.CreateNetworkResponse.ReadOnly]
  def deleteNetworkSite(request: DeleteNetworkSiteRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly
  ]
  def createNetworkSite(request: CreateNetworkSiteRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.CreateNetworkSiteResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.UntagResourceResponse.ReadOnly]
  def getDeviceIdentifier(request: GetDeviceIdentifierRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly
  ]
  def listNetworks(
      request: ListNetworksRequest
  ): ZStream[Any, AwsError, zio.aws.privatenetworks.model.Network.ReadOnly]
  def listNetworksPaginated(
      request: ListNetworksRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.ListNetworksResponse.ReadOnly]
  def activateDeviceIdentifier(request: ActivateDeviceIdentifierRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly
  ]
  def updateNetworkSite(request: UpdateNetworkSiteRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.UpdateNetworkSiteResponse.ReadOnly
  ]
  def getOrder(
      request: GetOrderRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listNetworkSites(
      request: ListNetworkSitesRequest
  ): ZStream[Any, AwsError, zio.aws.privatenetworks.model.NetworkSite.ReadOnly]
  def listNetworkSitesPaginated(request: ListNetworkSitesRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.TagResourceResponse.ReadOnly]
  def updateNetworkSitePlan(request: UpdateNetworkSitePlanRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.UpdateNetworkSitePlanResponse.ReadOnly
  ]
  def getNetworkSite(
      request: GetNetworkSiteRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly]
  def listNetworkResources(request: ListNetworkResourcesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.privatenetworks.model.NetworkResource.ReadOnly
  ]
  def listNetworkResourcesPaginated(request: ListNetworkResourcesRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly
  ]
  def ping(): IO[AwsError, zio.aws.privatenetworks.model.PingResponse.ReadOnly]
  def listOrders(
      request: ListOrdersRequest
  ): ZStream[Any, AwsError, zio.aws.privatenetworks.model.Order.ReadOnly]
  def listOrdersPaginated(
      request: ListOrdersRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly]
  def deleteNetwork(
      request: DeleteNetworkRequest
  ): IO[AwsError, zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly]
  def getNetworkResource(request: GetNetworkResourceRequest): IO[
    AwsError,
    zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly
  ]
  def deactivateDeviceIdentifier(
      request: DeactivateDeviceIdentifierRequest
  ): IO[
    AwsError,
    zio.aws.privatenetworks.model.DeactivateDeviceIdentifierResponse.ReadOnly
  ]
}
object PrivateNetworks {
  val live: ZLayer[AwsConfig, java.lang.Throwable, PrivateNetworks] =
    customized(identity)
  def customized(
      customization: PrivateNetworksAsyncClientBuilder => PrivateNetworksAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, PrivateNetworks] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PrivateNetworksAsyncClientBuilder => PrivateNetworksAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, PrivateNetworks] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = PrivateNetworksAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[PrivateNetworksAsyncClient, PrivateNetworksAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      PrivateNetworksAsyncClient,
      PrivateNetworksAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new PrivateNetworksImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class PrivateNetworksImpl[R](
      override val api: PrivateNetworksAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends PrivateNetworks
      with AwsServiceBase[R] {
    override val serviceName: String = "PrivateNetworks"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PrivateNetworksImpl[R1] = new PrivateNetworksImpl(api, newAspect, r)
    def acknowledgeOrderReceipt(request: AcknowledgeOrderReceiptRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest,
      AcknowledgeOrderReceiptResponse
    ]("acknowledgeOrderReceipt", api.acknowledgeOrderReceipt)(
      request.buildAwsValue()
    ).map(zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.wrap)
      .provideEnvironment(r)
    def activateNetworkSite(request: ActivateNetworkSiteRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest,
      ActivateNetworkSiteResponse
    ]("activateNetworkSite", api.activateNetworkSite)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.wrap)
      .provideEnvironment(r)
    def getNetwork(
        request: GetNetworkRequest
    ): IO[AwsError, zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest,
        GetNetworkResponse
      ]("getNetwork", api.getNetwork)(request.buildAwsValue())
        .map(zio.aws.privatenetworks.model.GetNetworkResponse.wrap)
        .provideEnvironment(r)
    def listDeviceIdentifiers(
        request: ListDeviceIdentifiersRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest,
      DeviceIdentifier,
      ListDeviceIdentifiersPublisher
    ](
      "listDeviceIdentifiers",
      api.listDeviceIdentifiersPaginator,
      _.deviceIdentifiers()
    )(request.buildAwsValue())
      .map(item => zio.aws.privatenetworks.model.DeviceIdentifier.wrap(item))
      .provideEnvironment(r)
    def listDeviceIdentifiersPaginated(
        request: ListDeviceIdentifiersRequest
    ): IO[
      AwsError,
      zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest,
      ListDeviceIdentifiersResponse
    ]("listDeviceIdentifiers", api.listDeviceIdentifiers)(
      request.buildAwsValue()
    ).map(zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.wrap)
      .provideEnvironment(r)
    def configureAccessPoint(request: ConfigureAccessPointRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest,
      ConfigureAccessPointResponse
    ]("configureAccessPoint", api.configureAccessPoint)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.ConfigureAccessPointResponse.wrap)
      .provideEnvironment(r)
    def createNetwork(request: CreateNetworkRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.CreateNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest,
      CreateNetworkResponse
    ]("createNetwork", api.createNetwork)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.CreateNetworkResponse.wrap)
      .provideEnvironment(r)
    def deleteNetworkSite(request: DeleteNetworkSiteRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest,
      DeleteNetworkSiteResponse
    ]("deleteNetworkSite", api.deleteNetworkSite)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.wrap)
      .provideEnvironment(r)
    def createNetworkSite(request: CreateNetworkSiteRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.CreateNetworkSiteResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest,
      CreateNetworkSiteResponse
    ]("createNetworkSite", api.createNetworkSite)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.CreateNetworkSiteResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getDeviceIdentifier(request: GetDeviceIdentifierRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest,
      GetDeviceIdentifierResponse
    ]("getDeviceIdentifier", api.getDeviceIdentifier)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.wrap)
      .provideEnvironment(r)
    def listNetworks(request: ListNetworksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.Network.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest,
      Network,
      ListNetworksPublisher
    ]("listNetworks", api.listNetworksPaginator, _.networks())(
      request.buildAwsValue()
    ).map(item => zio.aws.privatenetworks.model.Network.wrap(item))
      .provideEnvironment(r)
    def listNetworksPaginated(request: ListNetworksRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.ListNetworksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest,
      ListNetworksResponse
    ]("listNetworks", api.listNetworks)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.ListNetworksResponse.wrap)
      .provideEnvironment(r)
    def activateDeviceIdentifier(request: ActivateDeviceIdentifierRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest,
      ActivateDeviceIdentifierResponse
    ]("activateDeviceIdentifier", api.activateDeviceIdentifier)(
      request.buildAwsValue()
    ).map(zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.wrap)
      .provideEnvironment(r)
    def updateNetworkSite(request: UpdateNetworkSiteRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.UpdateNetworkSiteResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest,
      UpdateNetworkSiteResponse
    ]("updateNetworkSite", api.updateNetworkSite)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.UpdateNetworkSiteResponse.wrap)
      .provideEnvironment(r)
    def getOrder(
        request: GetOrderRequest
    ): IO[AwsError, zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest,
        GetOrderResponse
      ]("getOrder", api.getOrder)(request.buildAwsValue())
        .map(zio.aws.privatenetworks.model.GetOrderResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listNetworkSites(request: ListNetworkSitesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkSite.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest,
      NetworkSite,
      ListNetworkSitesPublisher
    ]("listNetworkSites", api.listNetworkSitesPaginator, _.networkSites())(
      request.buildAwsValue()
    ).map(item => zio.aws.privatenetworks.model.NetworkSite.wrap(item))
      .provideEnvironment(r)
    def listNetworkSitesPaginated(request: ListNetworkSitesRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest,
      ListNetworkSitesResponse
    ]("listNetworkSites", api.listNetworkSites)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.ListNetworkSitesResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateNetworkSitePlan(request: UpdateNetworkSitePlanRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.UpdateNetworkSitePlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest,
      UpdateNetworkSitePlanResponse
    ]("updateNetworkSitePlan", api.updateNetworkSitePlan)(
      request.buildAwsValue()
    ).map(zio.aws.privatenetworks.model.UpdateNetworkSitePlanResponse.wrap)
      .provideEnvironment(r)
    def getNetworkSite(request: GetNetworkSiteRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest,
      GetNetworkSiteResponse
    ]("getNetworkSite", api.getNetworkSite)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.GetNetworkSiteResponse.wrap)
      .provideEnvironment(r)
    def listNetworkResources(request: ListNetworkResourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest,
      NetworkResource,
      ListNetworkResourcesPublisher
    ](
      "listNetworkResources",
      api.listNetworkResourcesPaginator,
      _.networkResources()
    )(request.buildAwsValue())
      .map(item => zio.aws.privatenetworks.model.NetworkResource.wrap(item))
      .provideEnvironment(r)
    def listNetworkResourcesPaginated(request: ListNetworkResourcesRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest,
      ListNetworkResourcesResponse
    ]("listNetworkResources", api.listNetworkResources)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.ListNetworkResourcesResponse.wrap)
      .provideEnvironment(r)
    def ping()
        : IO[AwsError, zio.aws.privatenetworks.model.PingResponse.ReadOnly] =
      asyncRequestResponse[PingRequest, PingResponse]("ping", api.ping)(
        PingRequest.builder().build()
      ).map(zio.aws.privatenetworks.model.PingResponse.wrap)
        .provideEnvironment(r)
    def listOrders(
        request: ListOrdersRequest
    ): ZStream[Any, AwsError, zio.aws.privatenetworks.model.Order.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest,
        Order,
        ListOrdersPublisher
      ]("listOrders", api.listOrdersPaginator, _.orders())(
        request.buildAwsValue()
      ).map(item => zio.aws.privatenetworks.model.Order.wrap(item))
        .provideEnvironment(r)
    def listOrdersPaginated(
        request: ListOrdersRequest
    ): IO[AwsError, zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest,
        ListOrdersResponse
      ]("listOrders", api.listOrders)(request.buildAwsValue())
        .map(zio.aws.privatenetworks.model.ListOrdersResponse.wrap)
        .provideEnvironment(r)
    def deleteNetwork(request: DeleteNetworkRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest,
      DeleteNetworkResponse
    ]("deleteNetwork", api.deleteNetwork)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.DeleteNetworkResponse.wrap)
      .provideEnvironment(r)
    def getNetworkResource(request: GetNetworkResourceRequest): IO[
      AwsError,
      zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest,
      GetNetworkResourceResponse
    ]("getNetworkResource", api.getNetworkResource)(request.buildAwsValue())
      .map(zio.aws.privatenetworks.model.GetNetworkResourceResponse.wrap)
      .provideEnvironment(r)
    def deactivateDeviceIdentifier(
        request: DeactivateDeviceIdentifierRequest
    ): IO[
      AwsError,
      zio.aws.privatenetworks.model.DeactivateDeviceIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest,
      DeactivateDeviceIdentifierResponse
    ]("deactivateDeviceIdentifier", api.deactivateDeviceIdentifier)(
      request.buildAwsValue()
    ).map(zio.aws.privatenetworks.model.DeactivateDeviceIdentifierResponse.wrap)
      .provideEnvironment(r)
  }
  def acknowledgeOrderReceipt(request: AcknowledgeOrderReceiptRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.AcknowledgeOrderReceiptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acknowledgeOrderReceipt(request))
  def activateNetworkSite(request: ActivateNetworkSiteRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activateNetworkSite(request))
  def getNetwork(request: GetNetworkRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.GetNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetwork(request))
  def listDeviceIdentifiers(
      request: ListDeviceIdentifiersRequest
  ): ZStream[zio.aws.privatenetworks.PrivateNetworks, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listDeviceIdentifiers(request))
  def listDeviceIdentifiersPaginated(
      request: ListDeviceIdentifiersRequest
  ): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeviceIdentifiersPaginated(request))
  def configureAccessPoint(request: ConfigureAccessPointRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.configureAccessPoint(request))
  def createNetwork(request: CreateNetworkRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.CreateNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetwork(request))
  def deleteNetworkSite(request: DeleteNetworkSiteRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.DeleteNetworkSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkSite(request))
  def createNetworkSite(request: CreateNetworkSiteRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.CreateNetworkSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkSite(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getDeviceIdentifier(request: GetDeviceIdentifierRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.GetDeviceIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeviceIdentifier(request))
  def listNetworks(request: ListNetworksRequest): ZStream[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.Network.ReadOnly
  ] = ZStream.serviceWithStream(_.listNetworks(request))
  def listNetworksPaginated(request: ListNetworksRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ListNetworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNetworksPaginated(request))
  def activateDeviceIdentifier(request: ActivateDeviceIdentifierRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activateDeviceIdentifier(request))
  def updateNetworkSite(request: UpdateNetworkSiteRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.UpdateNetworkSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNetworkSite(request))
  def getOrder(request: GetOrderRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOrder(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listNetworkSites(request: ListNetworkSitesRequest): ZStream[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.NetworkSite.ReadOnly
  ] = ZStream.serviceWithStream(_.listNetworkSites(request))
  def listNetworkSitesPaginated(request: ListNetworkSitesRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNetworkSitesPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateNetworkSitePlan(request: UpdateNetworkSitePlanRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.UpdateNetworkSitePlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNetworkSitePlan(request))
  def getNetworkSite(request: GetNetworkSiteRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.GetNetworkSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkSite(request))
  def listNetworkResources(request: ListNetworkResourcesRequest): ZStream[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.NetworkResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listNetworkResources(request))
  def listNetworkResourcesPaginated(request: ListNetworkResourcesRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNetworkResourcesPaginated(request))
  def ping(): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.PingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.ping())
  def listOrders(request: ListOrdersRequest): ZStream[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.Order.ReadOnly
  ] = ZStream.serviceWithStream(_.listOrders(request))
  def listOrdersPaginated(request: ListOrdersRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrdersPaginated(request))
  def deleteNetwork(request: DeleteNetworkRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetwork(request))
  def getNetworkResource(request: GetNetworkResourceRequest): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.GetNetworkResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkResource(request))
  def deactivateDeviceIdentifier(
      request: DeactivateDeviceIdentifierRequest
  ): ZIO[
    zio.aws.privatenetworks.PrivateNetworks,
    AwsError,
    zio.aws.privatenetworks.model.DeactivateDeviceIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deactivateDeviceIdentifier(request))
}
