package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDomainDeliverabilityCampaignsResponse(
    domainDeliverabilityCampaigns: Iterable[
      zio.aws.pinpointemail.model.DomainDeliverabilityCampaign
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse = {
    import ListDomainDeliverabilityCampaignsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse
      .builder()
      .domainDeliverabilityCampaigns(domainDeliverabilityCampaigns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly =
    zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse
      .wrap(buildAwsValue())
}
object ListDomainDeliverabilityCampaignsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse =
      zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse(
        domainDeliverabilityCampaigns.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def domainDeliverabilityCampaigns: List[
      zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getDomainDeliverabilityCampaigns: ZIO[Any, Nothing, List[
      zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
    ]] = ZIO.succeed(domainDeliverabilityCampaigns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse
  ) extends zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly {
    override val domainDeliverabilityCampaigns: List[
      zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
    ] = impl
      .domainDeliverabilityCampaigns()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse
  ): zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly =
    new Wrapper(impl)
}
