package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDeliverabilityTestReportsResponse(
    deliverabilityTestReports: Iterable[
      zio.aws.pinpointemail.model.DeliverabilityTestReport
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse = {
    import ListDeliverabilityTestReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse
      .builder()
      .deliverabilityTestReports(deliverabilityTestReports.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly =
    zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse
      .wrap(buildAwsValue())
}
object ListDeliverabilityTestReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse =
      zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse(
        deliverabilityTestReports.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def deliverabilityTestReports
        : List[zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDeliverabilityTestReports: ZIO[Any, Nothing, List[
      zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
    ]] = ZIO.succeed(deliverabilityTestReports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse
  ) extends zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly {
    override val deliverabilityTestReports
        : List[zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly] =
      impl
        .deliverabilityTestReports()
        .asScala
        .map { item =>
          zio.aws.pinpointemail.model.DeliverabilityTestReport.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse
  ): zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly =
    new Wrapper(impl)
}
