package zio.aws.pinpointemail.model
import zio.prelude.data.Optional
import zio.aws.pinpointemail.model.primitives.{MaxItems, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDedicatedIpPoolsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest = {
    import ListDedicatedIpPoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest.ReadOnly =
    zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest
      .wrap(buildAwsValue())
}
object ListDedicatedIpPoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest =
      zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest(
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest
  ) extends zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.pinpointemail.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest
  ): zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest.ReadOnly =
    new Wrapper(impl)
}
