package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.CampaignId
import scala.jdk.CollectionConverters.*
final case class GetDomainDeliverabilityCampaignRequest(
    campaignId: CampaignId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest = {
    import GetDomainDeliverabilityCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
      .builder()
      .campaignId(CampaignId.unwrap(campaignId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest.ReadOnly =
    zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
      .wrap(buildAwsValue())
}
object GetDomainDeliverabilityCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest =
      zio.aws.pinpointemail.model
        .GetDomainDeliverabilityCampaignRequest(campaignId)
    def campaignId: CampaignId
    def getCampaignId: ZIO[Any, Nothing, CampaignId] = ZIO.succeed(campaignId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
  ) extends zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest.ReadOnly {
    override val campaignId: CampaignId =
      zio.aws.pinpointemail.model.primitives.CampaignId(impl.campaignId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
  ): zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest.ReadOnly =
    new Wrapper(impl)
}
