package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.BlacklistItemName
import scala.jdk.CollectionConverters.*
final case class GetBlacklistReportsResponse(
    blacklistReport: Map[BlacklistItemName, Iterable[
      zio.aws.pinpointemail.model.BlacklistEntry
    ]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse = {
    import GetBlacklistReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse
      .builder()
      .blacklistReport(
        blacklistReport
          .map({ case (key, value) =>
            (BlacklistItemName.unwrap(key): java.lang.String) -> value.map {
              item =>
                item.buildAwsValue()
            }.asJavaCollection
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetBlacklistReportsResponse
      .wrap(buildAwsValue())
}
object GetBlacklistReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetBlacklistReportsResponse =
      zio.aws.pinpointemail.model
        .GetBlacklistReportsResponse(blacklistReport.map({ case (key, value) =>
          key -> value.map { item =>
            item.asEditable
          }
        }))
    def blacklistReport: Map[BlacklistItemName, List[
      zio.aws.pinpointemail.model.BlacklistEntry.ReadOnly
    ]]
    def getBlacklistReport: ZIO[Any, Nothing, Map[BlacklistItemName, List[
      zio.aws.pinpointemail.model.BlacklistEntry.ReadOnly
    ]]] = ZIO.succeed(blacklistReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse
  ) extends zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly {
    override val blacklistReport: Map[BlacklistItemName, List[
      zio.aws.pinpointemail.model.BlacklistEntry.ReadOnly
    ]] = impl
      .blacklistReport()
      .asScala
      .map({ case (key, value) =>
        zio.aws.pinpointemail.model.primitives
          .BlacklistItemName(key) -> value.asScala.map { item =>
          zio.aws.pinpointemail.model.BlacklistEntry.wrap(item)
        }.toList
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse
  ): zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly =
    new Wrapper(impl)
}
