package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.BlacklistItemName
import scala.jdk.CollectionConverters.*
final case class GetBlacklistReportsRequest(
    blacklistItemNames: Iterable[BlacklistItemName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest = {
    import GetBlacklistReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest
      .builder()
      .blacklistItemNames(blacklistItemNames.map { item =>
        BlacklistItemName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetBlacklistReportsRequest.ReadOnly =
    zio.aws.pinpointemail.model.GetBlacklistReportsRequest.wrap(buildAwsValue())
}
object GetBlacklistReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetBlacklistReportsRequest =
      zio.aws.pinpointemail.model.GetBlacklistReportsRequest(blacklistItemNames)
    def blacklistItemNames: List[BlacklistItemName]
    def getBlacklistItemNames: ZIO[Any, Nothing, List[BlacklistItemName]] =
      ZIO.succeed(blacklistItemNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest
  ) extends zio.aws.pinpointemail.model.GetBlacklistReportsRequest.ReadOnly {
    override val blacklistItemNames: List[BlacklistItemName] = impl
      .blacklistItemNames()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.primitives.BlacklistItemName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest
  ): zio.aws.pinpointemail.model.GetBlacklistReportsRequest.ReadOnly =
    new Wrapper(impl)
}
