package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.ReportId
import scala.jdk.CollectionConverters.*
final case class CreateDeliverabilityTestReportResponse(
    reportId: ReportId,
    deliverabilityTestStatus: zio.aws.pinpointemail.model.DeliverabilityTestStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse = {
    import CreateDeliverabilityTestReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .deliverabilityTestStatus(deliverabilityTestStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly =
    zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse
      .wrap(buildAwsValue())
}
object CreateDeliverabilityTestReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse =
      zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse(
        reportId,
        deliverabilityTestStatus
      )
    def reportId: ReportId
    def deliverabilityTestStatus
        : zio.aws.pinpointemail.model.DeliverabilityTestStatus
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
    def getDeliverabilityTestStatus: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointemail.model.DeliverabilityTestStatus
    ] = ZIO.succeed(deliverabilityTestStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse
  ) extends zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly {
    override val reportId: ReportId =
      zio.aws.pinpointemail.model.primitives.ReportId(impl.reportId())
    override val deliverabilityTestStatus
        : zio.aws.pinpointemail.model.DeliverabilityTestStatus =
      zio.aws.pinpointemail.model.DeliverabilityTestStatus
        .wrap(impl.deliverabilityTestStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse
  ): zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly =
    new Wrapper(impl)
}
