package zio.aws.pinpointemail.model
import scala.jdk.CollectionConverters.*
sealed trait TlsPolicy {
  def unwrap: software.amazon.awssdk.services.pinpointemail.model.TlsPolicy
}
object TlsPolicy {
  def wrap(
      value: software.amazon.awssdk.services.pinpointemail.model.TlsPolicy
  ): zio.aws.pinpointemail.model.TlsPolicy = value match {
    case software.amazon.awssdk.services.pinpointemail.model.TlsPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointemail.model.TlsPolicy.REQUIRE =>
      val r = REQUIRE
      r
    case software.amazon.awssdk.services.pinpointemail.model.TlsPolicy.OPTIONAL =>
      val r = OPTIONAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointemail.model.TlsPolicy {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.TlsPolicy =
      software.amazon.awssdk.services.pinpointemail.model.TlsPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object REQUIRE extends zio.aws.pinpointemail.model.TlsPolicy {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.TlsPolicy =
      software.amazon.awssdk.services.pinpointemail.model.TlsPolicy.REQUIRE
  }
  case object OPTIONAL extends zio.aws.pinpointemail.model.TlsPolicy {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.TlsPolicy =
      software.amazon.awssdk.services.pinpointemail.model.TlsPolicy.OPTIONAL
  }
}
