package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.RawMessageData
import scala.jdk.CollectionConverters.*
final case class RawMessage(data: RawMessageData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.RawMessage = {
    import RawMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.RawMessage
      .builder()
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.RawMessage.ReadOnly =
    zio.aws.pinpointemail.model.RawMessage.wrap(buildAwsValue())
}
object RawMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.RawMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.RawMessage =
      zio.aws.pinpointemail.model.RawMessage(data)
    def data: RawMessageData
    def getData: ZIO[Any, Nothing, RawMessageData] = ZIO.succeed(data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.RawMessage
  ) extends zio.aws.pinpointemail.model.RawMessage.ReadOnly {
    override val data: RawMessageData = zio.aws.pinpointemail.model.primitives
      .RawMessageData(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.RawMessage
  ): zio.aws.pinpointemail.model.RawMessage.ReadOnly = new Wrapper(impl)
}
