package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Percentage
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OverallVolume(
    volumeStatistics: Optional[zio.aws.pinpointemail.model.VolumeStatistics] =
      Optional.Absent,
    readRatePercent: Optional[Percentage] = Optional.Absent,
    domainIspPlacements: Optional[
      Iterable[zio.aws.pinpointemail.model.DomainIspPlacement]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.OverallVolume = {
    import OverallVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.OverallVolume
      .builder()
      .optionallyWith(volumeStatistics.map(value => value.buildAwsValue()))(
        _.volumeStatistics
      )
      .optionallyWith(
        readRatePercent.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.readRatePercent)
      .optionallyWith(
        domainIspPlacements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainIspPlacements)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.OverallVolume.ReadOnly =
    zio.aws.pinpointemail.model.OverallVolume.wrap(buildAwsValue())
}
object OverallVolume {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.OverallVolume
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.OverallVolume =
      zio.aws.pinpointemail.model.OverallVolume(
        volumeStatistics.map(value => value.asEditable),
        readRatePercent.map(value => value),
        domainIspPlacements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeStatistics
        : Optional[zio.aws.pinpointemail.model.VolumeStatistics.ReadOnly]
    def readRatePercent: Optional[Percentage]
    def domainIspPlacements: Optional[
      List[zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly]
    ]
    def getVolumeStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.VolumeStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("volumeStatistics", volumeStatistics)
    def getReadRatePercent: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("readRatePercent", readRatePercent)
    def getDomainIspPlacements: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly
    ]] = AwsError.unwrapOptionField("domainIspPlacements", domainIspPlacements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.OverallVolume
  ) extends zio.aws.pinpointemail.model.OverallVolume.ReadOnly {
    override val volumeStatistics
        : Optional[zio.aws.pinpointemail.model.VolumeStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeStatistics())
        .map(value => zio.aws.pinpointemail.model.VolumeStatistics.wrap(value))
    override val readRatePercent: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.readRatePercent())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val domainIspPlacements: Optional[
      List[zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIspPlacements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.DomainIspPlacement.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.OverallVolume
  ): zio.aws.pinpointemail.model.OverallVolume.ReadOnly = new Wrapper(impl)
}
