package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Enabled, Identity}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IdentityInfo(
    identityType: Optional[zio.aws.pinpointemail.model.IdentityType] =
      Optional.Absent,
    identityName: Optional[Identity] = Optional.Absent,
    sendingEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.IdentityInfo = {
    import IdentityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.IdentityInfo
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        identityName.map(value => Identity.unwrap(value): java.lang.String)
      )(_.identityName)
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.IdentityInfo.ReadOnly =
    zio.aws.pinpointemail.model.IdentityInfo.wrap(buildAwsValue())
}
object IdentityInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.IdentityInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.IdentityInfo =
      zio.aws.pinpointemail.model.IdentityInfo(
        identityType.map(value => value),
        identityName.map(value => value),
        sendingEnabled.map(value => value)
      )
    def identityType: Optional[zio.aws.pinpointemail.model.IdentityType]
    def identityName: Optional[Identity]
    def sendingEnabled: Optional[Enabled]
    def getIdentityType
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getIdentityName: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("identityName", identityName)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.IdentityInfo
  ) extends zio.aws.pinpointemail.model.IdentityInfo.ReadOnly {
    override val identityType
        : Optional[zio.aws.pinpointemail.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.pinpointemail.model.IdentityType.wrap(value))
    override val identityName: Optional[Identity] = zio.aws.core.internal
      .optionalFromNullable(impl.identityName())
      .map(value => zio.aws.pinpointemail.model.primitives.Identity(value))
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.IdentityInfo
  ): zio.aws.pinpointemail.model.IdentityInfo.ReadOnly = new Wrapper(impl)
}
