package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Enabled
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAccountSendingAttributesRequest(
    sendingEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest = {
    import PutAccountSendingAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest
      .builder()
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest
      .wrap(buildAwsValue())
}
object PutAccountSendingAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest =
      zio.aws.pinpointemail.model
        .PutAccountSendingAttributesRequest(sendingEnabled.map(value => value))
    def sendingEnabled: Optional[Enabled]
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest
  ) extends zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest.ReadOnly {
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest
  ): zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
