package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.pinpointemail.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.ListTagsForResourceRequest =
      zio.aws.pinpointemail.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AmazonResourceName
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest
  ) extends zio.aws.pinpointemail.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.pinpointemail.model.primitives
        .AmazonResourceName(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest
  ): zio.aws.pinpointemail.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
