package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Enabled, EventDestinationName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventDestination(
    name: EventDestinationName,
    enabled: Optional[Enabled] = Optional.Absent,
    matchingEventTypes: Iterable[zio.aws.pinpointemail.model.EventType],
    kinesisFirehoseDestination: Optional[
      zio.aws.pinpointemail.model.KinesisFirehoseDestination
    ] = Optional.Absent,
    cloudWatchDestination: Optional[
      zio.aws.pinpointemail.model.CloudWatchDestination
    ] = Optional.Absent,
    snsDestination: Optional[zio.aws.pinpointemail.model.SnsDestination] =
      Optional.Absent,
    pinpointDestination: Optional[
      zio.aws.pinpointemail.model.PinpointDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.EventDestination = {
    import EventDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.EventDestination
      .builder()
      .name(EventDestinationName.unwrap(name): java.lang.String)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .matchingEventTypesWithStrings(matchingEventTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        kinesisFirehoseDestination.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseDestination)
      .optionallyWith(
        cloudWatchDestination.map(value => value.buildAwsValue())
      )(_.cloudWatchDestination)
      .optionallyWith(snsDestination.map(value => value.buildAwsValue()))(
        _.snsDestination
      )
      .optionallyWith(pinpointDestination.map(value => value.buildAwsValue()))(
        _.pinpointDestination
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.EventDestination.ReadOnly =
    zio.aws.pinpointemail.model.EventDestination.wrap(buildAwsValue())
}
object EventDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.EventDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.EventDestination =
      zio.aws.pinpointemail.model.EventDestination(
        name,
        enabled.map(value => value),
        matchingEventTypes,
        kinesisFirehoseDestination.map(value => value.asEditable),
        cloudWatchDestination.map(value => value.asEditable),
        snsDestination.map(value => value.asEditable),
        pinpointDestination.map(value => value.asEditable)
      )
    def name: EventDestinationName
    def enabled: Optional[Enabled]
    def matchingEventTypes: List[zio.aws.pinpointemail.model.EventType]
    def kinesisFirehoseDestination: Optional[
      zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly
    ]
    def cloudWatchDestination
        : Optional[zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly]
    def snsDestination
        : Optional[zio.aws.pinpointemail.model.SnsDestination.ReadOnly]
    def pinpointDestination
        : Optional[zio.aws.pinpointemail.model.PinpointDestination.ReadOnly]
    def getName: ZIO[Any, Nothing, EventDestinationName] = ZIO.succeed(name)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getMatchingEventTypes
        : ZIO[Any, Nothing, List[zio.aws.pinpointemail.model.EventType]] =
      ZIO.succeed(matchingEventTypes)
    def getKinesisFirehoseDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseDestination",
      kinesisFirehoseDestination
    )
    def getCloudWatchDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly
    ] =
      AwsError.unwrapOptionField("cloudWatchDestination", cloudWatchDestination)
    def getSnsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.SnsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("snsDestination", snsDestination)
    def getPinpointDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.PinpointDestination.ReadOnly
    ] = AwsError.unwrapOptionField("pinpointDestination", pinpointDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.EventDestination
  ) extends zio.aws.pinpointemail.model.EventDestination.ReadOnly {
    override val name: EventDestinationName =
      zio.aws.pinpointemail.model.primitives.EventDestinationName(impl.name())
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val matchingEventTypes
        : List[zio.aws.pinpointemail.model.EventType] = impl
      .matchingEventTypes()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.EventType.wrap(item)
      }
      .toList
    override val kinesisFirehoseDestination: Optional[
      zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseDestination())
      .map(value =>
        zio.aws.pinpointemail.model.KinesisFirehoseDestination.wrap(value)
      )
    override val cloudWatchDestination
        : Optional[zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchDestination())
        .map(value =>
          zio.aws.pinpointemail.model.CloudWatchDestination.wrap(value)
        )
    override val snsDestination
        : Optional[zio.aws.pinpointemail.model.SnsDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snsDestination())
        .map(value => zio.aws.pinpointemail.model.SnsDestination.wrap(value))
    override val pinpointDestination
        : Optional[zio.aws.pinpointemail.model.PinpointDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pinpointDestination())
        .map(value =>
          zio.aws.pinpointemail.model.PinpointDestination.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.EventDestination
  ): zio.aws.pinpointemail.model.EventDestination.ReadOnly = new Wrapper(impl)
}
