package zio.aws.pinpointemail.model
import scala.jdk.CollectionConverters.*
sealed trait DeliverabilityTestStatus {
  def unwrap: software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus
}
object DeliverabilityTestStatus {
  def wrap(
      value: software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus
  ): zio.aws.pinpointemail.model.DeliverabilityTestStatus = value match {
    case software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointemail.model.DeliverabilityTestStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus =
      software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends zio.aws.pinpointemail.model.DeliverabilityTestStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus =
      software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus.IN_PROGRESS
  }
  case object COMPLETED
      extends zio.aws.pinpointemail.model.DeliverabilityTestStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus =
      software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus.COMPLETED
  }
}
