package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Enabled
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEmailIdentityResponse(
    identityType: Optional[zio.aws.pinpointemail.model.IdentityType] =
      Optional.Absent,
    verifiedForSendingStatus: Optional[Enabled] = Optional.Absent,
    dkimAttributes: Optional[zio.aws.pinpointemail.model.DkimAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse = {
    import CreateEmailIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        verifiedForSendingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.verifiedForSendingStatus)
      .optionallyWith(dkimAttributes.map(value => value.buildAwsValue()))(
        _.dkimAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly =
    zio.aws.pinpointemail.model.CreateEmailIdentityResponse
      .wrap(buildAwsValue())
}
object CreateEmailIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.CreateEmailIdentityResponse =
      zio.aws.pinpointemail.model.CreateEmailIdentityResponse(
        identityType.map(value => value),
        verifiedForSendingStatus.map(value => value),
        dkimAttributes.map(value => value.asEditable)
      )
    def identityType: Optional[zio.aws.pinpointemail.model.IdentityType]
    def verifiedForSendingStatus: Optional[Enabled]
    def dkimAttributes
        : Optional[zio.aws.pinpointemail.model.DkimAttributes.ReadOnly]
    def getIdentityType
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getVerifiedForSendingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("verifiedForSendingStatus", verifiedForSendingStatus)
    def getDkimAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DkimAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dkimAttributes", dkimAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse
  ) extends zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly {
    override val identityType
        : Optional[zio.aws.pinpointemail.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.pinpointemail.model.IdentityType.wrap(value))
    override val verifiedForSendingStatus: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedForSendingStatus())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val dkimAttributes
        : Optional[zio.aws.pinpointemail.model.DkimAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dkimAttributes())
        .map(value => zio.aws.pinpointemail.model.DkimAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse
  ): zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
