package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Iterable[zio.aws.pinpointemail.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.pinpointemail.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.ListTagsForResourceResponse =
      zio.aws.pinpointemail.model.ListTagsForResourceResponse(tags.map { item =>
        item.asEditable
      })
    def tags: List[zio.aws.pinpointemail.model.Tag.ReadOnly]
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse
  ) extends zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: List[zio.aws.pinpointemail.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse
  ): zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
