package zio.aws.pinpointemail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.pinpointemail.model.primitives.{Timestamp, Domain}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DomainDeliverabilityTrackingOption(
    domain: Optional[Domain] = Optional.Absent,
    subscriptionStartDate: Optional[Timestamp] = Optional.Absent,
    inboxPlacementTrackingOption: Optional[
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption = {
    import DomainDeliverabilityTrackingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
      .builder()
      .optionallyWith(
        domain.map(value => Domain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        subscriptionStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.subscriptionStartDate)
      .optionallyWith(
        inboxPlacementTrackingOption.map(value => value.buildAwsValue())
      )(_.inboxPlacementTrackingOption)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly =
    zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption
      .wrap(buildAwsValue())
}
object DomainDeliverabilityTrackingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption =
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption(
        domain.map(value => value),
        subscriptionStartDate.map(value => value),
        inboxPlacementTrackingOption.map(value => value.asEditable)
      )
    def domain: Optional[Domain]
    def subscriptionStartDate: Optional[Timestamp]
    def inboxPlacementTrackingOption: Optional[
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly
    ]
    def getDomain: ZIO[Any, AwsError, Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getSubscriptionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionStartDate", subscriptionStartDate)
    def getInboxPlacementTrackingOption: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inboxPlacementTrackingOption",
      inboxPlacementTrackingOption
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
  ) extends zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly {
    override val domain: Optional[Domain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.pinpointemail.model.primitives.Domain(value))
    override val subscriptionStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionStartDate())
        .map(value => zio.aws.pinpointemail.model.primitives.Timestamp(value))
    override val inboxPlacementTrackingOption: Optional[
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inboxPlacementTrackingOption())
      .map(value =>
        zio.aws.pinpointemail.model.InboxPlacementTrackingOption.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
  ): zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly =
    new Wrapper(impl)
}
