package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters.*
final case class SnsDestination(topicArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.SnsDestination = {
    import SnsDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.SnsDestination
      .builder()
      .topicArn(AmazonResourceName.unwrap(topicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.SnsDestination.ReadOnly =
    zio.aws.pinpointemail.model.SnsDestination.wrap(buildAwsValue())
}
object SnsDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.SnsDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.SnsDestination =
      zio.aws.pinpointemail.model.SnsDestination(topicArn)
    def topicArn: AmazonResourceName
    def getTopicArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.SnsDestination
  ) extends zio.aws.pinpointemail.model.SnsDestination.ReadOnly {
    override val topicArn: AmazonResourceName =
      zio.aws.pinpointemail.model.primitives.AmazonResourceName(impl.topicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.SnsDestination
  ): zio.aws.pinpointemail.model.SnsDestination.ReadOnly = new Wrapper(impl)
}
