package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Enabled, ConfigurationSetName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetSendingOptionsRequest(
    configurationSetName: ConfigurationSetName,
    sendingEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest = {
    import PutConfigurationSetSendingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetSendingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest =
      zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest(
        configurationSetName,
        sendingEnabled.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def sendingEnabled: Optional[Enabled]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
  ) extends zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
  ): zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
