package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{
  GeneralEnforcementStatus,
  Enabled
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccountResponse(
    sendQuota: Optional[zio.aws.pinpointemail.model.SendQuota] =
      Optional.Absent,
    sendingEnabled: Optional[Enabled] = Optional.Absent,
    dedicatedIpAutoWarmupEnabled: Optional[Enabled] = Optional.Absent,
    enforcementStatus: Optional[GeneralEnforcementStatus] = Optional.Absent,
    productionAccessEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse = {
    import GetAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
      .builder()
      .optionallyWith(sendQuota.map(value => value.buildAwsValue()))(
        _.sendQuota
      )
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .optionallyWith(
        dedicatedIpAutoWarmupEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.dedicatedIpAutoWarmupEnabled)
      .optionallyWith(
        enforcementStatus.map(value =>
          GeneralEnforcementStatus.unwrap(value): java.lang.String
        )
      )(_.enforcementStatus)
      .optionallyWith(
        productionAccessEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.productionAccessEnabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetAccountResponse.wrap(buildAwsValue())
}
object GetAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetAccountResponse =
      zio.aws.pinpointemail.model.GetAccountResponse(
        sendQuota.map(value => value.asEditable),
        sendingEnabled.map(value => value),
        dedicatedIpAutoWarmupEnabled.map(value => value),
        enforcementStatus.map(value => value),
        productionAccessEnabled.map(value => value)
      )
    def sendQuota: Optional[zio.aws.pinpointemail.model.SendQuota.ReadOnly]
    def sendingEnabled: Optional[Enabled]
    def dedicatedIpAutoWarmupEnabled: Optional[Enabled]
    def enforcementStatus: Optional[GeneralEnforcementStatus]
    def productionAccessEnabled: Optional[Enabled]
    def getSendQuota
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.SendQuota.ReadOnly] =
      AwsError.unwrapOptionField("sendQuota", sendQuota)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
    def getDedicatedIpAutoWarmupEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField(
        "dedicatedIpAutoWarmupEnabled",
        dedicatedIpAutoWarmupEnabled
      )
    def getEnforcementStatus: ZIO[Any, AwsError, GeneralEnforcementStatus] =
      AwsError.unwrapOptionField("enforcementStatus", enforcementStatus)
    def getProductionAccessEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("productionAccessEnabled", productionAccessEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
  ) extends zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly {
    override val sendQuota
        : Optional[zio.aws.pinpointemail.model.SendQuota.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sendQuota())
        .map(value => zio.aws.pinpointemail.model.SendQuota.wrap(value))
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val dedicatedIpAutoWarmupEnabled: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedIpAutoWarmupEnabled())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val enforcementStatus: Optional[GeneralEnforcementStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enforcementStatus())
        .map(value =>
          zio.aws.pinpointemail.model.primitives.GeneralEnforcementStatus(value)
        )
    override val productionAccessEnabled: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productionAccessEnabled())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
  ): zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly = new Wrapper(impl)
}
