package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.PoolName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeliveryOptions(
    tlsPolicy: Optional[zio.aws.pinpointemail.model.TlsPolicy] =
      Optional.Absent,
    sendingPoolName: Optional[PoolName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DeliveryOptions = {
    import DeliveryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DeliveryOptions
      .builder()
      .optionallyWith(tlsPolicy.map(value => value.unwrap))(_.tlsPolicy)
      .optionallyWith(
        sendingPoolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.sendingPoolName)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly =
    zio.aws.pinpointemail.model.DeliveryOptions.wrap(buildAwsValue())
}
object DeliveryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DeliveryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DeliveryOptions =
      zio.aws.pinpointemail.model.DeliveryOptions(
        tlsPolicy.map(value => value),
        sendingPoolName.map(value => value)
      )
    def tlsPolicy: Optional[zio.aws.pinpointemail.model.TlsPolicy]
    def sendingPoolName: Optional[PoolName]
    def getTlsPolicy
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.TlsPolicy] =
      AwsError.unwrapOptionField("tlsPolicy", tlsPolicy)
    def getSendingPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("sendingPoolName", sendingPoolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeliveryOptions
  ) extends zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly {
    override val tlsPolicy: Optional[zio.aws.pinpointemail.model.TlsPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsPolicy())
        .map(value => zio.aws.pinpointemail.model.TlsPolicy.wrap(value))
    override val sendingPoolName: Optional[PoolName] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingPoolName())
      .map(value => zio.aws.pinpointemail.model.primitives.PoolName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeliveryOptions
  ): zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly = new Wrapper(impl)
}
