package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.{PoolName, Ip}
import scala.jdk.CollectionConverters.*
final case class PutDedicatedIpInPoolRequest(
    ip: Ip,
    destinationPoolName: PoolName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest = {
    import PutDedicatedIpInPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest
      .builder()
      .ip(Ip.unwrap(ip): java.lang.String)
      .destinationPoolName(
        PoolName.unwrap(destinationPoolName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest
      .wrap(buildAwsValue())
}
object PutDedicatedIpInPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest =
      zio.aws.pinpointemail.model
        .PutDedicatedIpInPoolRequest(ip, destinationPoolName)
    def ip: Ip
    def destinationPoolName: PoolName
    def getIp: ZIO[Any, Nothing, Ip] = ZIO.succeed(ip)
    def getDestinationPoolName: ZIO[Any, Nothing, PoolName] =
      ZIO.succeed(destinationPoolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest
  ) extends zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest.ReadOnly {
    override val ip: Ip = zio.aws.pinpointemail.model.primitives.Ip(impl.ip())
    override val destinationPoolName: PoolName =
      zio.aws.pinpointemail.model.primitives
        .PoolName(impl.destinationPoolName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest
  ): zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest.ReadOnly =
    new Wrapper(impl)
}
