package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Enabled, ConfigurationSetName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetReputationOptionsRequest(
    configurationSetName: ConfigurationSetName,
    reputationMetricsEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest = {
    import PutConfigurationSetReputationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        reputationMetricsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.reputationMetricsEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetReputationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest =
      zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest(
        configurationSetName,
        reputationMetricsEnabled.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def reputationMetricsEnabled: Optional[Enabled]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getReputationMetricsEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("reputationMetricsEnabled", reputationMetricsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
  ) extends zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val reputationMetricsEnabled: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reputationMetricsEnabled())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
  ): zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
