package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters.*
final case class KinesisFirehoseDestination(
    iamRoleArn: AmazonResourceName,
    deliveryStreamArn: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.KinesisFirehoseDestination = {
    import KinesisFirehoseDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.KinesisFirehoseDestination
      .builder()
      .iamRoleArn(AmazonResourceName.unwrap(iamRoleArn): java.lang.String)
      .deliveryStreamArn(
        AmazonResourceName.unwrap(deliveryStreamArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly =
    zio.aws.pinpointemail.model.KinesisFirehoseDestination.wrap(buildAwsValue())
}
object KinesisFirehoseDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.KinesisFirehoseDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.KinesisFirehoseDestination =
      zio.aws.pinpointemail.model
        .KinesisFirehoseDestination(iamRoleArn, deliveryStreamArn)
    def iamRoleArn: AmazonResourceName
    def deliveryStreamArn: AmazonResourceName
    def getIamRoleArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(iamRoleArn)
    def getDeliveryStreamArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(deliveryStreamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.KinesisFirehoseDestination
  ) extends zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly {
    override val iamRoleArn: AmazonResourceName =
      zio.aws.pinpointemail.model.primitives
        .AmazonResourceName(impl.iamRoleArn())
    override val deliveryStreamArn: AmazonResourceName =
      zio.aws.pinpointemail.model.primitives
        .AmazonResourceName(impl.deliveryStreamArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.KinesisFirehoseDestination
  ): zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly =
    new Wrapper(impl)
}
