package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Enabled
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetEmailIdentityResponse(
    identityType: Optional[zio.aws.pinpointemail.model.IdentityType] =
      Optional.Absent,
    feedbackForwardingStatus: Optional[Enabled] = Optional.Absent,
    verifiedForSendingStatus: Optional[Enabled] = Optional.Absent,
    dkimAttributes: Optional[zio.aws.pinpointemail.model.DkimAttributes] =
      Optional.Absent,
    mailFromAttributes: Optional[
      zio.aws.pinpointemail.model.MailFromAttributes
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointemail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse = {
    import GetEmailIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        feedbackForwardingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.feedbackForwardingStatus)
      .optionallyWith(
        verifiedForSendingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.verifiedForSendingStatus)
      .optionallyWith(dkimAttributes.map(value => value.buildAwsValue()))(
        _.dkimAttributes
      )
      .optionallyWith(mailFromAttributes.map(value => value.buildAwsValue()))(
        _.mailFromAttributes
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetEmailIdentityResponse.wrap(buildAwsValue())
}
object GetEmailIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetEmailIdentityResponse =
      zio.aws.pinpointemail.model.GetEmailIdentityResponse(
        identityType.map(value => value),
        feedbackForwardingStatus.map(value => value),
        verifiedForSendingStatus.map(value => value),
        dkimAttributes.map(value => value.asEditable),
        mailFromAttributes.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def identityType: Optional[zio.aws.pinpointemail.model.IdentityType]
    def feedbackForwardingStatus: Optional[Enabled]
    def verifiedForSendingStatus: Optional[Enabled]
    def dkimAttributes
        : Optional[zio.aws.pinpointemail.model.DkimAttributes.ReadOnly]
    def mailFromAttributes
        : Optional[zio.aws.pinpointemail.model.MailFromAttributes.ReadOnly]
    def tags: Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]]
    def getIdentityType
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getFeedbackForwardingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("feedbackForwardingStatus", feedbackForwardingStatus)
    def getVerifiedForSendingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("verifiedForSendingStatus", verifiedForSendingStatus)
    def getDkimAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DkimAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dkimAttributes", dkimAttributes)
    def getMailFromAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.MailFromAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("mailFromAttributes", mailFromAttributes)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse
  ) extends zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly {
    override val identityType
        : Optional[zio.aws.pinpointemail.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.pinpointemail.model.IdentityType.wrap(value))
    override val feedbackForwardingStatus: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.feedbackForwardingStatus())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val verifiedForSendingStatus: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedForSendingStatus())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val dkimAttributes
        : Optional[zio.aws.pinpointemail.model.DkimAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dkimAttributes())
        .map(value => zio.aws.pinpointemail.model.DkimAttributes.wrap(value))
    override val mailFromAttributes
        : Optional[zio.aws.pinpointemail.model.MailFromAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mailFromAttributes())
        .map(value =>
          zio.aws.pinpointemail.model.MailFromAttributes.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse
  ): zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
