package zio.aws.pinpointemail.model
import scala.jdk.CollectionConverters.*
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.pinpointemail.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.pinpointemail.model.EventType
  ): zio.aws.pinpointemail.model.EventType = value match {
    case software.amazon.awssdk.services.pinpointemail.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.SEND =>
      val r = SEND
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.REJECT =>
      val r = REJECT
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.BOUNCE =>
      val r = BOUNCE
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.COMPLAINT =>
      val r = COMPLAINT
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.DELIVERY =>
      val r = DELIVERY
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.CLICK =>
      val r = CLICK
      r
    case software.amazon.awssdk.services.pinpointemail.model.EventType.RENDERING_FAILURE =>
      val r = RENDERING_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object SEND extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.SEND
  }
  case object REJECT extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.REJECT
  }
  case object BOUNCE extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.BOUNCE
  }
  case object COMPLAINT extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.COMPLAINT
  }
  case object DELIVERY extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.DELIVERY
  }
  case object OPEN extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.OPEN
  }
  case object CLICK extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.CLICK
  }
  case object RENDERING_FAILURE extends zio.aws.pinpointemail.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.EventType =
      software.amazon.awssdk.services.pinpointemail.model.EventType.RENDERING_FAILURE
  }
}
