package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Enabled
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventDestinationDefinition(
    enabled: Optional[Enabled] = Optional.Absent,
    matchingEventTypes: Optional[
      Iterable[zio.aws.pinpointemail.model.EventType]
    ] = Optional.Absent,
    kinesisFirehoseDestination: Optional[
      zio.aws.pinpointemail.model.KinesisFirehoseDestination
    ] = Optional.Absent,
    cloudWatchDestination: Optional[
      zio.aws.pinpointemail.model.CloudWatchDestination
    ] = Optional.Absent,
    snsDestination: Optional[zio.aws.pinpointemail.model.SnsDestination] =
      Optional.Absent,
    pinpointDestination: Optional[
      zio.aws.pinpointemail.model.PinpointDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.EventDestinationDefinition = {
    import EventDestinationDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.EventDestinationDefinition
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        matchingEventTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.matchingEventTypesWithStrings)
      .optionallyWith(
        kinesisFirehoseDestination.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseDestination)
      .optionallyWith(
        cloudWatchDestination.map(value => value.buildAwsValue())
      )(_.cloudWatchDestination)
      .optionallyWith(snsDestination.map(value => value.buildAwsValue()))(
        _.snsDestination
      )
      .optionallyWith(pinpointDestination.map(value => value.buildAwsValue()))(
        _.pinpointDestination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.EventDestinationDefinition.ReadOnly =
    zio.aws.pinpointemail.model.EventDestinationDefinition.wrap(buildAwsValue())
}
object EventDestinationDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.EventDestinationDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.EventDestinationDefinition =
      zio.aws.pinpointemail.model.EventDestinationDefinition(
        enabled.map(value => value),
        matchingEventTypes.map(value => value),
        kinesisFirehoseDestination.map(value => value.asEditable),
        cloudWatchDestination.map(value => value.asEditable),
        snsDestination.map(value => value.asEditable),
        pinpointDestination.map(value => value.asEditable)
      )
    def enabled: Optional[Enabled]
    def matchingEventTypes
        : Optional[List[zio.aws.pinpointemail.model.EventType]]
    def kinesisFirehoseDestination: Optional[
      zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly
    ]
    def cloudWatchDestination
        : Optional[zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly]
    def snsDestination
        : Optional[zio.aws.pinpointemail.model.SnsDestination.ReadOnly]
    def pinpointDestination
        : Optional[zio.aws.pinpointemail.model.PinpointDestination.ReadOnly]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getMatchingEventTypes
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.EventType]] =
      AwsError.unwrapOptionField("matchingEventTypes", matchingEventTypes)
    def getKinesisFirehoseDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseDestination",
      kinesisFirehoseDestination
    )
    def getCloudWatchDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly
    ] =
      AwsError.unwrapOptionField("cloudWatchDestination", cloudWatchDestination)
    def getSnsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.SnsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("snsDestination", snsDestination)
    def getPinpointDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.PinpointDestination.ReadOnly
    ] = AwsError.unwrapOptionField("pinpointDestination", pinpointDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.EventDestinationDefinition
  ) extends zio.aws.pinpointemail.model.EventDestinationDefinition.ReadOnly {
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val matchingEventTypes
        : Optional[List[zio.aws.pinpointemail.model.EventType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchingEventTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.EventType.wrap(item)
          }.toList
        )
    override val kinesisFirehoseDestination: Optional[
      zio.aws.pinpointemail.model.KinesisFirehoseDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseDestination())
      .map(value =>
        zio.aws.pinpointemail.model.KinesisFirehoseDestination.wrap(value)
      )
    override val cloudWatchDestination
        : Optional[zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchDestination())
        .map(value =>
          zio.aws.pinpointemail.model.CloudWatchDestination.wrap(value)
        )
    override val snsDestination
        : Optional[zio.aws.pinpointemail.model.SnsDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snsDestination())
        .map(value => zio.aws.pinpointemail.model.SnsDestination.wrap(value))
    override val pinpointDestination
        : Optional[zio.aws.pinpointemail.model.PinpointDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pinpointDestination())
        .map(value =>
          zio.aws.pinpointemail.model.PinpointDestination.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.EventDestinationDefinition
  ): zio.aws.pinpointemail.model.EventDestinationDefinition.ReadOnly =
    new Wrapper(impl)
}
