package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.{
  DefaultDimensionValue,
  DimensionName
}
import scala.jdk.CollectionConverters.*
final case class CloudWatchDimensionConfiguration(
    dimensionName: DimensionName,
    dimensionValueSource: zio.aws.pinpointemail.model.DimensionValueSource,
    defaultDimensionValue: DefaultDimensionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CloudWatchDimensionConfiguration = {
    import CloudWatchDimensionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CloudWatchDimensionConfiguration
      .builder()
      .dimensionName(DimensionName.unwrap(dimensionName): java.lang.String)
      .dimensionValueSource(dimensionValueSource.unwrap)
      .defaultDimensionValue(
        DefaultDimensionValue.unwrap(defaultDimensionValue): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration.ReadOnly =
    zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration
      .wrap(buildAwsValue())
}
object CloudWatchDimensionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CloudWatchDimensionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration =
      zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration(
        dimensionName,
        dimensionValueSource,
        defaultDimensionValue
      )
    def dimensionName: DimensionName
    def dimensionValueSource: zio.aws.pinpointemail.model.DimensionValueSource
    def defaultDimensionValue: DefaultDimensionValue
    def getDimensionName: ZIO[Any, Nothing, DimensionName] =
      ZIO.succeed(dimensionName)
    def getDimensionValueSource
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.DimensionValueSource] =
      ZIO.succeed(dimensionValueSource)
    def getDefaultDimensionValue: ZIO[Any, Nothing, DefaultDimensionValue] =
      ZIO.succeed(defaultDimensionValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CloudWatchDimensionConfiguration
  ) extends zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration.ReadOnly {
    override val dimensionName: DimensionName =
      zio.aws.pinpointemail.model.primitives.DimensionName(impl.dimensionName())
    override val dimensionValueSource
        : zio.aws.pinpointemail.model.DimensionValueSource =
      zio.aws.pinpointemail.model.DimensionValueSource
        .wrap(impl.dimensionValueSource())
    override val defaultDimensionValue: DefaultDimensionValue =
      zio.aws.pinpointemail.model.primitives
        .DefaultDimensionValue(impl.defaultDimensionValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CloudWatchDimensionConfiguration
  ): zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration.ReadOnly =
    new Wrapper(impl)
}
