package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEmailIdentitiesResponse(
    emailIdentities: Option[
      Iterable[zio.aws.pinpointemail.model.IdentityInfo]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse = {
    import ListEmailIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse
      .builder()
      .optionallyWith(
        emailIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emailIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly =
    zio.aws.pinpointemail.model.ListEmailIdentitiesResponse
      .wrap(buildAwsValue())
}
object ListEmailIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.ListEmailIdentitiesResponse =
      zio.aws.pinpointemail.model.ListEmailIdentitiesResponse(
        emailIdentities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def emailIdentities
        : Option[List[zio.aws.pinpointemail.model.IdentityInfo.ReadOnly]]
    def nextToken: Option[NextToken]
    def getEmailIdentities: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.IdentityInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("emailIdentities", emailIdentities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse
  ) extends zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly {
    override val emailIdentities
        : Option[List[zio.aws.pinpointemail.model.IdentityInfo.ReadOnly]] =
      scala
        .Option(impl.emailIdentities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.IdentityInfo.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse
  ): zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly =
    new Wrapper(impl)
}
