package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Percentage, Volume, IspName}
import scala.jdk.CollectionConverters.*
final case class DomainIspPlacement(
    ispName: Option[IspName] = None,
    inboxRawCount: Option[Volume] = None,
    spamRawCount: Option[Volume] = None,
    inboxPercentage: Option[Percentage] = None,
    spamPercentage: Option[Percentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DomainIspPlacement = {
    import DomainIspPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DomainIspPlacement
      .builder()
      .optionallyWith(
        ispName.map(value => IspName.unwrap(value): java.lang.String)
      )(_.ispName)
      .optionallyWith(
        inboxRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.inboxRawCount)
      .optionallyWith(
        spamRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.spamRawCount)
      .optionallyWith(
        inboxPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.inboxPercentage)
      .optionallyWith(
        spamPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.spamPercentage)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly =
    zio.aws.pinpointemail.model.DomainIspPlacement.wrap(buildAwsValue())
}
object DomainIspPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DomainIspPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DomainIspPlacement =
      zio.aws.pinpointemail.model.DomainIspPlacement(
        ispName.map(value => value),
        inboxRawCount.map(value => value),
        spamRawCount.map(value => value),
        inboxPercentage.map(value => value),
        spamPercentage.map(value => value)
      )
    def ispName: Option[IspName]
    def inboxRawCount: Option[Volume]
    def spamRawCount: Option[Volume]
    def inboxPercentage: Option[Percentage]
    def spamPercentage: Option[Percentage]
    def getIspName: ZIO[Any, AwsError, IspName] =
      AwsError.unwrapOptionField("ispName", ispName)
    def getInboxRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("inboxRawCount", inboxRawCount)
    def getSpamRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("spamRawCount", spamRawCount)
    def getInboxPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("inboxPercentage", inboxPercentage)
    def getSpamPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("spamPercentage", spamPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainIspPlacement
  ) extends zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly {
    override val ispName: Option[IspName] = scala
      .Option(impl.ispName())
      .map(value => zio.aws.pinpointemail.model.primitives.IspName(value))
    override val inboxRawCount: Option[Volume] = scala
      .Option(impl.inboxRawCount())
      .map(value => zio.aws.pinpointemail.model.primitives.Volume(value))
    override val spamRawCount: Option[Volume] = scala
      .Option(impl.spamRawCount())
      .map(value => zio.aws.pinpointemail.model.primitives.Volume(value))
    override val inboxPercentage: Option[Percentage] = scala
      .Option(impl.inboxPercentage())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val spamPercentage: Option[Percentage] = scala
      .Option(impl.spamPercentage())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainIspPlacement
  ): zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly = new Wrapper(impl)
}
