package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Body(
    text: Option[zio.aws.pinpointemail.model.Content] = None,
    html: Option[zio.aws.pinpointemail.model.Content] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.Body = {
    import Body.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.Body
      .builder()
      .optionallyWith(text.map(value => value.buildAwsValue()))(_.text)
      .optionallyWith(html.map(value => value.buildAwsValue()))(_.html)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.Body.ReadOnly =
    zio.aws.pinpointemail.model.Body.wrap(buildAwsValue())
}
object Body {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.Body
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.Body =
      zio.aws.pinpointemail.model.Body(
        text.map(value => value.asEditable),
        html.map(value => value.asEditable)
      )
    def text: Option[zio.aws.pinpointemail.model.Content.ReadOnly]
    def html: Option[zio.aws.pinpointemail.model.Content.ReadOnly]
    def getText
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.Content.ReadOnly] =
      AwsError.unwrapOptionField("text", text)
    def getHtml
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.Content.ReadOnly] =
      AwsError.unwrapOptionField("html", html)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.Body
  ) extends zio.aws.pinpointemail.model.Body.ReadOnly {
    override val text: Option[zio.aws.pinpointemail.model.Content.ReadOnly] =
      scala
        .Option(impl.text())
        .map(value => zio.aws.pinpointemail.model.Content.wrap(value))
    override val html: Option[zio.aws.pinpointemail.model.Content.ReadOnly] =
      scala
        .Option(impl.html())
        .map(value => zio.aws.pinpointemail.model.Content.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.Body
  ): zio.aws.pinpointemail.model.Body.ReadOnly = new Wrapper(impl)
}
