package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters.*
final case class PinpointDestination(
    applicationArn: Option[AmazonResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PinpointDestination = {
    import PinpointDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PinpointDestination
      .builder()
      .optionallyWith(
        applicationArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.applicationArn)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.PinpointDestination.ReadOnly =
    zio.aws.pinpointemail.model.PinpointDestination.wrap(buildAwsValue())
}
object PinpointDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PinpointDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.PinpointDestination =
      zio.aws.pinpointemail.model
        .PinpointDestination(applicationArn.map(value => value))
    def applicationArn: Option[AmazonResourceName]
    def getApplicationArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("applicationArn", applicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PinpointDestination
  ) extends zio.aws.pinpointemail.model.PinpointDestination.ReadOnly {
    override val applicationArn: Option[AmazonResourceName] = scala
      .Option(impl.applicationArn())
      .map(value =>
        zio.aws.pinpointemail.model.primitives.AmazonResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PinpointDestination
  ): zio.aws.pinpointemail.model.PinpointDestination.ReadOnly = new Wrapper(
    impl
  )
}
