package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{NextToken, ConfigurationSetName}
import scala.jdk.CollectionConverters.*
final case class ListConfigurationSetsResponse(
    configurationSets: Option[Iterable[ConfigurationSetName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse = {
    import ListConfigurationSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse
      .builder()
      .optionallyWith(
        configurationSets.map(value =>
          value.map { item =>
            ConfigurationSetName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configurationSets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly =
    zio.aws.pinpointemail.model.ListConfigurationSetsResponse
      .wrap(buildAwsValue())
}
object ListConfigurationSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.ListConfigurationSetsResponse =
      zio.aws.pinpointemail.model.ListConfigurationSetsResponse(
        configurationSets.map(value => value),
        nextToken.map(value => value)
      )
    def configurationSets: Option[List[ConfigurationSetName]]
    def nextToken: Option[NextToken]
    def getConfigurationSets: ZIO[Any, AwsError, List[ConfigurationSetName]] =
      AwsError.unwrapOptionField("configurationSets", configurationSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse
  ) extends zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly {
    override val configurationSets: Option[List[ConfigurationSetName]] = scala
      .Option(impl.configurationSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.primitives.ConfigurationSetName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse
  ): zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly =
    new Wrapper(impl)
}
