package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.ConfigurationSetName
import scala.jdk.CollectionConverters.*
final case class GetConfigurationSetEventDestinationsRequest(
    configurationSetName: ConfigurationSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest = {
    import GetConfigurationSetEventDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest.ReadOnly =
    zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
      .wrap(buildAwsValue())
}
object GetConfigurationSetEventDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest =
      zio.aws.pinpointemail.model
        .GetConfigurationSetEventDestinationsRequest(configurationSetName)
    def configurationSetName: ConfigurationSetName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
  ) extends zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
  ): zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest.ReadOnly =
    new Wrapper(impl)
}
