package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{
  SentLast24Hours,
  MaxSendRate,
  Max24HourSend
}
import scala.jdk.CollectionConverters.*
final case class SendQuota(
    max24HourSend: Option[Max24HourSend] = None,
    maxSendRate: Option[MaxSendRate] = None,
    sentLast24Hours: Option[SentLast24Hours] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.SendQuota = {
    import SendQuota.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.SendQuota
      .builder()
      .optionallyWith(
        max24HourSend.map(value =>
          Max24HourSend.unwrap(value): java.lang.Double
        )
      )(_.max24HourSend)
      .optionallyWith(
        maxSendRate.map(value => MaxSendRate.unwrap(value): java.lang.Double)
      )(_.maxSendRate)
      .optionallyWith(
        sentLast24Hours.map(value =>
          SentLast24Hours.unwrap(value): java.lang.Double
        )
      )(_.sentLast24Hours)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.SendQuota.ReadOnly =
    zio.aws.pinpointemail.model.SendQuota.wrap(buildAwsValue())
}
object SendQuota {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.SendQuota
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.SendQuota =
      zio.aws.pinpointemail.model.SendQuota(
        max24HourSend.map(value => value),
        maxSendRate.map(value => value),
        sentLast24Hours.map(value => value)
      )
    def max24HourSend: Option[Max24HourSend]
    def maxSendRate: Option[MaxSendRate]
    def sentLast24Hours: Option[SentLast24Hours]
    def getMax24HourSend: ZIO[Any, AwsError, Max24HourSend] =
      AwsError.unwrapOptionField("max24HourSend", max24HourSend)
    def getMaxSendRate: ZIO[Any, AwsError, MaxSendRate] =
      AwsError.unwrapOptionField("maxSendRate", maxSendRate)
    def getSentLast24Hours: ZIO[Any, AwsError, SentLast24Hours] =
      AwsError.unwrapOptionField("sentLast24Hours", sentLast24Hours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendQuota
  ) extends zio.aws.pinpointemail.model.SendQuota.ReadOnly {
    override val max24HourSend: Option[Max24HourSend] = scala
      .Option(impl.max24HourSend())
      .map(value => zio.aws.pinpointemail.model.primitives.Max24HourSend(value))
    override val maxSendRate: Option[MaxSendRate] = scala
      .Option(impl.maxSendRate())
      .map(value => zio.aws.pinpointemail.model.primitives.MaxSendRate(value))
    override val sentLast24Hours: Option[SentLast24Hours] = scala
      .Option(impl.sentLast24Hours())
      .map(value =>
        zio.aws.pinpointemail.model.primitives.SentLast24Hours(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendQuota
  ): zio.aws.pinpointemail.model.SendQuota.ReadOnly = new Wrapper(impl)
}
