package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{NextToken, PoolName}
import scala.jdk.CollectionConverters.*
final case class ListDedicatedIpPoolsResponse(
    dedicatedIpPools: Option[Iterable[PoolName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse = {
    import ListDedicatedIpPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse
      .builder()
      .optionallyWith(
        dedicatedIpPools.map(value =>
          value.map { item =>
            PoolName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dedicatedIpPools)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly =
    zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse
      .wrap(buildAwsValue())
}
object ListDedicatedIpPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse =
      zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse(
        dedicatedIpPools.map(value => value),
        nextToken.map(value => value)
      )
    def dedicatedIpPools: Option[List[PoolName]]
    def nextToken: Option[NextToken]
    def getDedicatedIpPools: ZIO[Any, AwsError, List[PoolName]] =
      AwsError.unwrapOptionField("dedicatedIpPools", dedicatedIpPools)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse
  ) extends zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly {
    override val dedicatedIpPools: Option[List[PoolName]] = scala
      .Option(impl.dedicatedIpPools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.primitives.PoolName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse
  ): zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly =
    new Wrapper(impl)
}
