package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{IspName, Enabled}
import scala.jdk.CollectionConverters.*
final case class InboxPlacementTrackingOption(
    global: Option[Enabled] = None,
    trackedIsps: Option[Iterable[IspName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.InboxPlacementTrackingOption = {
    import InboxPlacementTrackingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.InboxPlacementTrackingOption
      .builder()
      .optionallyWith(
        global.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.global)
      .optionallyWith(
        trackedIsps.map(value =>
          value.map { item =>
            IspName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trackedIsps)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly =
    zio.aws.pinpointemail.model.InboxPlacementTrackingOption
      .wrap(buildAwsValue())
}
object InboxPlacementTrackingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.InboxPlacementTrackingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.InboxPlacementTrackingOption =
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption(
        global.map(value => value),
        trackedIsps.map(value => value)
      )
    def global: Option[Enabled]
    def trackedIsps: Option[List[IspName]]
    def getGlobal: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("global", global)
    def getTrackedIsps: ZIO[Any, AwsError, List[IspName]] =
      AwsError.unwrapOptionField("trackedIsps", trackedIsps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.InboxPlacementTrackingOption
  ) extends zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly {
    override val global: Option[Enabled] = scala
      .Option(impl.global())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val trackedIsps: Option[List[IspName]] = scala
      .Option(impl.trackedIsps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.primitives.IspName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.InboxPlacementTrackingOption
  ): zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly =
    new Wrapper(impl)
}
