package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.Identity
import scala.jdk.CollectionConverters.*
final case class GetEmailIdentityRequest(emailIdentity: Identity) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest = {
    import GetEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.GetEmailIdentityRequest.ReadOnly =
    zio.aws.pinpointemail.model.GetEmailIdentityRequest.wrap(buildAwsValue())
}
object GetEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetEmailIdentityRequest =
      zio.aws.pinpointemail.model.GetEmailIdentityRequest(emailIdentity)
    def emailIdentity: Identity
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest
  ) extends zio.aws.pinpointemail.model.GetEmailIdentityRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.pinpointemail.model.primitives.Identity(impl.emailIdentity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest
  ): zio.aws.pinpointemail.model.GetEmailIdentityRequest.ReadOnly = new Wrapper(
    impl
  )
}
