package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.ConfigurationSetName
import scala.jdk.CollectionConverters.*
final case class GetConfigurationSetRequest(
    configurationSetName: ConfigurationSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest = {
    import GetConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetConfigurationSetRequest.ReadOnly =
    zio.aws.pinpointemail.model.GetConfigurationSetRequest.wrap(buildAwsValue())
}
object GetConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetConfigurationSetRequest =
      zio.aws.pinpointemail.model
        .GetConfigurationSetRequest(configurationSetName)
    def configurationSetName: ConfigurationSetName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest
  ) extends zio.aws.pinpointemail.model.GetConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest
  ): zio.aws.pinpointemail.model.GetConfigurationSetRequest.ReadOnly =
    new Wrapper(impl)
}
